/*
 * Decompiled with CFR 0.152.
 */
package com.ordana.immersive_weathering.data.block_growths.growths.builtin;

import com.ordana.immersive_weathering.blocks.FulguriteBlock;
import com.ordana.immersive_weathering.blocks.crackable.Crackable;
import com.ordana.immersive_weathering.configs.CommonConfigs;
import com.ordana.immersive_weathering.data.block_growths.TickSource;
import com.ordana.immersive_weathering.data.block_growths.growths.builtin.BuiltinBlockGrowth;
import com.ordana.immersive_weathering.reg.ModBlocks;
import com.ordana.immersive_weathering.reg.ModTags;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2378;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3481;
import net.minecraft.class_6005;
import net.minecraft.class_6008;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import org.jetbrains.annotations.Nullable;

public class LightningGrowth
extends BuiltinBlockGrowth {
    public static final class_6005<class_2350> list = class_6005.method_34971().method_34975((Object)class_2350.field_11036, 7).method_34975((Object)class_2350.field_11033, 1).method_34975((Object)class_2350.field_11043, 1).method_34975((Object)class_2350.field_11034, 1).method_34975((Object)class_2350.field_11039, 1).method_34975((Object)class_2350.field_11035, 1).method_34974();

    public LightningGrowth(String name, @Nullable class_6885<class_2248> owners, List<TickSource> sources, float chance) {
        super(name, owners, sources, chance);
    }

    @Nullable
    public Iterable<class_2248> getOwners() {
        ArrayList<class_2248> blocks = new ArrayList<class_2248>();
        ((class_6885.class_6888)class_2378.field_11146.method_40266(class_3481.field_15466).get()).method_40239().forEach(h -> blocks.add((class_2248)h.comp_349()));
        ((class_6885.class_6888)class_2378.field_11146.method_40266(ModTags.CRACKABLE).get()).method_40239().forEach(h -> blocks.add((class_2248)h.comp_349()));
        return blocks;
    }

    @Override
    public void tryGrowing(class_2338 pos, class_2680 state, class_3218 level, Supplier<class_6880<class_1959>> biome) {
        this.onLightningHit(pos, (class_1937)level, 0);
    }

    public void onLightningHit(class_2338 centerPos, class_1937 level, int rec) {
        class_2338 downPos;
        if (this.growthChance != 1.0f && !(level.field_9229.method_43057() < this.growthChance)) {
            return;
        }
        if (rec == 0 && !CommonConfigs.VITRIFIED_LIGHTNING.get().booleanValue()) {
            return;
        }
        this.convert(level, centerPos);
        if (rec >= 5) {
            return;
        }
        float decrement = 0.7f;
        double p = Math.pow(decrement, ++rec);
        if ((rec == 0 || (double)level.field_9229.method_43057() < 1.0 * p) && this.isValidTarget(level, downPos = centerPos.method_10074())) {
            this.onLightningHit(downPos, level, rec);
        }
        for (class_2338 target : class_2338.method_25996((class_2338)centerPos, (int)1, (int)0, (int)1)) {
            if (!((double)level.field_9229.method_43057() < 0.3 * p) || target == centerPos || !this.isValidTarget(level, target)) continue;
            this.onLightningHit(target, level, rec);
        }
    }

    private boolean isValidTarget(class_1937 level, class_2338 pos) {
        class_2680 state = level.method_8320(pos);
        return state.method_26164(ModTags.CRACKABLE) || state.method_26164(class_3481.field_15466);
    }

    private void convert(class_1937 level, class_2338 pos) {
        class_2680 state = level.method_8320(pos);
        if (state instanceof Crackable) {
            level.method_8652(pos, Crackable.getCrackedBlock(state), 3);
        } else if (state.method_26164(class_3481.field_15466)) {
            class_2350 dir;
            class_2338 offset;
            level.method_8652(pos, ModBlocks.VITRIFIED_SAND.get().method_9564(), 3);
            if ((double)level.field_9229.method_43057() < CommonConfigs.FULGURITE_CHANCE.get() && level.method_8320(offset = pos.method_10093(dir = (class_2350)((class_6008.class_6010)list.method_34992(level.field_9229).get()).method_34983())).method_26215()) {
                level.method_8652(offset, (class_2680)((class_2680)ModBlocks.FULGURITE.get().method_9564().method_11657((class_2769)FulguriteBlock.field_27087, (Comparable)dir)).method_11657((class_2769)FulguriteBlock.POWERED, (Comparable)Boolean.valueOf(true)), 3);
            }
        }
    }
}

